﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Pracownicy wg wydziałów</TITLE>
		<script runat="server">
		
            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                bool pelneStanowisko = false;
                [Priority(1)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }		
   
	        void OnContextLoad(object sender, EventArgs args) {
	        }

            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Pracownik idx = (Pracownik)args.Row;
                colZatrudnienie.EditValue = GetStanowisko(idx[((ActualDate)dc[typeof(ActualDate)]).Actual]);
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }    
            
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" EncodeHTML="true"
                title="Pracownicy wg wydziałów|</strong>Wydział: <strong>{0}|</strong>Pośrednio: <strong>{1}|</strong>Okres: <strong>{2}|</strong>Data aktualności: <strong>{3}"
				DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio"
				DataMember2="KadryPracownicyViewInfo+PrParams.Okres" DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" onbeforerow="Grid1_BeforeRow"
				GroupData0="Workers.Info.Historia.Etat.Wydzial" GroupLine="{0}" Sort="Workers.Info.Historia.Etat.Wydzial.Nazwa,Nazwisko">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Left" DataMember="Kod" Caption="Kod" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Pracownik.NazwiskoImię" Caption="Pracownik" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn Width="30" Align="Left" ID="colZatrudnienie" Caption="Zatrudnienie" EncodeHTML="true"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
